<?php

defined('PF_VERSION') OR exit('Access denied');

/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (phucpm.it@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
function show_all_comment($list, $key, $avatar, $childClass = '')
{
    $str = '';
    foreach ($list as $item) {
        $permission = false;
        $token = '';
        if ($item->comment_user_id == current_user('user-id')) {
            $token = Pf_Plugin_CSRF::token($key . $item->id);
            $permission = true;
        }
        $str .= '<div class="media cmt ' . $childClass . '">';
        $str .=!empty($avatar[$item->comment_user_id]) ? '<img src="' . get_thumbnails($avatar[$item->comment_user_id]) . '" class="media-object pull-left avatar" alt="' . $item->comment_author . '" data="' . $item->comment_author . '">' : "<i class='fa fa-user media-object pull-left avatar text-color' style='font-size:60px' data-author='" . $item->comment_author . "'></i>";
        $str .= '<div class="media-body" data-token="' . $token . '" data-id=' . $item->id . '>';
        $str .= '<h5 class="media-heading cmt-block"><strong>' . $item->comment_author . '</strong><span class="text-muted pull-right"> ' . ago($item->comment_created_date) . '</span></h5>';
        $str .= '<div class="message"><p>' . nl2br(e($item->comment_content)) . '</p></div>';
        $str .= '<ul class="toolBar">';
        $str .= is_login() ? '<li><a href="#" class="btnReply">' . __('Reply', 'comment') . '</a>' : '';
        if ($permission) {
            $str .= '<li><a href="#" class="btnEdit" data-id=' . $item->id . '>' . __('Edit', 'comment') . '</a>';
            $str .= '<li><a href="#" class="btnRemove">' . __('Remove', 'comment') . '</a></li>';
        }
        $str .= '</ul>';
        if (!empty($item->children)) {
            $str .= show_all_comment($item->children, $key, $avatar, 'children');
        }
        $str .= '</div></div>';
    }
    return $str;
}

function get_users_comment($comments)
{
    return $comments->comment_user_id;
}
